extends KinematicBody2D

export(float) var MAX_SPEED = 100
export(float) var ACCELARATION = 25
export(float) var FRICTION = 0.3
export(float) var BLINK_SPEED = 1000

var motion = Vector2()
onready var screensize = get_viewport_rect().size


func _physics_process(delta):
	var input = get_input()
	perform_movement(input)
	clamp_position_to_screen()


func clamp_position_to_screen():
	position.x = clamp(position.x, 0, screensize.x)
	position.y = clamp(position.y, 0, screensize.y)

func perform_movement(input):
	update_view_dir(input)
	
	if input != Vector2():
		speed_up(input)
	else:
		slow_down()
	
	if Input.is_action_just_pressed("ui_select"):
		set_blink_speed(input)
	
	move_and_slide(motion)

func speed_up(input):
	motion += input * ACCELERATION
	motion.x = clamp(motion.x, -MAX_SPEED,MAX_SPEED)
	motion.y = clamp(motion.y, -MAX_SPEED,MAX_SPEED)

func set_blink_speed(input):
	motion.x = BLINK_SPEED * get_view_dir().x
	if input != Vector2():
		motion += 10*MAX_SPEED * get_view_dir()

func slow_down():
	motion *= 1-FRICTION

func update_view_dir(input):
	if input.x == 0:
		return
	
	$Sprite.flip_h = (input.x < 0)

func get_view_dir():
	if $Sprite.flip_h:
		return Vector2(-1,0)
	else:
		return Vector2(1,0)

func get_input():
	var input = Vector2()
	
	if Input.is_action_pressed("ui_right"):
		input.x = 1
	elif Input.is_action_pressed("ui_left"):
		input.x = -1
	elif Input.is_action_pressed("ui_down"):
		input.y = 1
	elif Input.is_action_pressed("ui_up"):
		input.y = -1
	
	return input
