extends KinematicBody2D

const MAX_SPEED = 100
const ACCELARATION = 25
const FRICTION = 0.3
const BLINK_SPEED = 1000

var motion = Vector2()
var screensize
var direction = "right"
var moving = false

func _ready():
	screensize = get_viewport_rect().size
	pass

func _physics_process(delta):
	
	if Input.is_action_pressed("ui_right"):
		motion.x = min(motion.x + ACCELARATION, MAX_SPEED)
		direction = "right"
		moving = true
		$Sprite.flip_h = false
	elif Input.is_action_pressed("ui_left"):
		motion.x = max(motion.x - ACCELARATION, -MAX_SPEED)
		direction = "left"
		$Sprite.flip_h = true
		moving = true
	elif Input.is_action_pressed("ui_down"):
		motion.y = min(motion.y + ACCELARATION, MAX_SPEED)
		moving = true
	elif Input.is_action_pressed("ui_up"):
		motion.y = max(motion.y - ACCELARATION, -MAX_SPEED)
		moving = true
	else:
		motion.x = lerp(motion.x, 0, FRICTION)
		motion.y = lerp(motion.y, 0, FRICTION)
		moving = false
	
	if Input.is_action_just_pressed("ui_select"):
		if moving == false:
			if direction == "right":
				motion.x = BLINK_SPEED
			else:
				motion.x = -BLINK_SPEED
		else:
			if direction == "right":
				motion.x = BLINK_SPEED + 10 * MAX_SPEED
			else:
				motion.x = -BLINK_SPEED

	
	move_and_slide(motion)
	
	position.x = clamp(position.x, 0, screensize.x)
	position.y = clamp(position.y, 0, screensize.y)
	
	pass