using Godot;

public class Player : Sprite
{
    [Export]
    float speed = 200.0f;

    AnimationPlayer anim;

    public override void _Ready()
    {
        anim = GetNode(new NodePath("AnimationPlayer")) 
               as AnimationPlayer;
    }

    public override void _Process(float delta)
    {
        var movement = new Vector2();

        if (Godot.Input.IsActionPressed("ui_right"))
        {
            movement.x += 1.0f;
        }
        if (Godot.Input.IsActionPressed("ui_left"))
        {
            movement.x -= 1.0f;
        }
        if (Godot.Input.IsActionPressed("ui_down"))
        {
            movement.y += 1.0f;
        }
        if (Godot.Input.IsActionPressed("ui_up"))
        {
            movement.y -= 1.0f;
        }

        Translate(movement.Normalized() * speed * delta);

        if (movement != new Vector2())
        {
            if (!anim.IsPlaying())
            {
                anim.Play("walk");
            }
        }
        else
        {
            anim.Stop();
        }
    }
}
