﻿namespace GodotFsBasicFs

open Godot
open GodotUtils
open Animations

module MyInput =
    let getInputDir = 
        Input.actionsToDir "ui_right" "ui_left" "ui_down" "ui_up"

type PlayerFs() as this =
    inherit Sprite()

    [<Export>]
    let speed = 200.0f

    let anim = this.getNode "AnimationPlayer"

    override this._Process(delta) =
        let dir = MyInput.getInputDir ()
        this.Translate(dir * speed * delta)
        visualize anim (dir <> new Vector2()) "walk"
        
