﻿module Input

open Godot

/// <summary>
/// Returns 1.0f if the given action is currently pressed, 0.0f otherwise
/// </summary>
/// <param name="key">action to be checked</param>
let actionToFactor key = 
    if Input.IsActionPressed(key) then 1.0f else 0.0f

/// <summary>
/// Returns 1.0f if pos is pressed, -1.0f if neg is pressed and 0.0f if both or none are pressed
/// </summary>
let actionsToFactor pos neg () =
    actionToFactor pos - actionToFactor neg

/// <summary>
/// Returns a 2d vector that points in the direction determined from the given input events.
/// </summary>
let actionsToDir right left down up () = 
    new Vector2(actionsToFactor right left (), actionsToFactor down up ())
