﻿module GodotUtils

open Godot

type Node with
    /// <summary>
    /// Gets a lazy reference to a node.
    /// </summary>
    /// <param name="path">Path to the node to be retrieved</param>
    member this.getNode<'a when 'a :> Node> (path:string) = 
        lazy((this.GetNode(new NodePath(path))) :?> 'a)
