﻿module Animations

open Godot

/// <summary>
/// Starts an animation unless it's already playing.
/// </summary>
let enableAnim (anim : Lazy<AnimationPlayer>) name =
    if 
        not (anim.Value.IsPlaying()) 
        || not (anim.Value.CurrentAnimation = name)
    then 
        anim.Value.Play(name)

/// <summary>
/// Makes sure that the animation plays if the condition is true
/// and stops if it isn't.
/// </summary>
/// <param name="anim">lazy reference to Godot AnimationPlayer node</param>
/// <param name="condition">condition that decides whether 
/// the animation should play</param>
/// <param name="name">name of the animation to play</param>
let visualize (anim : Lazy<AnimationPlayer>) condition name =
    if condition then (enableAnim anim name) else anim.Value.Stop()
