﻿namespace GodotFsBasicFs

open Godot

type PlayerFs() as this =
    inherit Sprite()

    [<Export>]
    let speed = 200.0f

    let anim = 
        lazy(
            this.GetNode(new NodePath("AnimationPlayer")) 
            :?> AnimationPlayer
            )

    override this._Process(delta) =
        let check key = 
            if Input.IsActionPressed(key) then 1.0f else 0.0f

        let movement = 
            new Vector2(check "ui_right" - check "ui_left", 
                        check "ui_down" - check "ui_up")

        this.Translate(movement.Normalized() * speed * delta)

        let isMoving = movement <> new Vector2()
        let enableAnim name = if not (anim.Value.IsPlaying()) then anim.Value.Play(name)
        if isMoving then enableAnim "walk" else anim.Value.Stop()
